<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_subsidiary".
 *
 * @property int $id
 * @property string $subsidiary_name
 * @property string $subsidiary_desc
 * @property int $subsidiary_order
 */
class Subsidiary extends \common\models\MasterModel
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_subsidiary';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['subsidiary_order'], 'integer'],
            [['subsidiary_name', 'subsidiary_desc'], 'string'],
            [['subsidiary_desc'], 'required'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'subsidiary_name' => 'Name',
            'subsidiary_desc' => 'Desc',
            'subsidiary_order' => 'Order',
        ];
    }

    public function getLatestOrder()
    {
        $subsidiary = Subsidiary::find()->orderBy(['subsidiary_order' => SORT_DESC])->one();
        if (!empty($subsidiary)) {
            return $subsidiary->subsidiary_order;
        }
        return 0;
    }
}
