<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-console',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'console\controllers',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'controllerMap' => [
        'fixture' => [
            'class' => 'yii\console\controllers\FixtureController',
            'namespace' => 'common\fixtures',
          ],
    ],
    'components' => [
        'request'=>[
            // 'class' => 'yii\console\Request',
            // 'hostInfo' => 'http://localhost',
            // 'baseUrl' => '/yii-project',
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'hostInfo' => 'https://www.marnova.co.id',
            'baseUrl' => '/',
            'rules' => [
            ],
        ],
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'user' => [
            'class' => 'yii\web\User',
            'identityClass' => 'app\models\FrontUser',
            // 'enableAutoLogin' => true,
            'enableSession' => false,
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@common/mail',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'us17.sharehostserver.com',//'newton.dnshostnetwork.com',
                'username' => 'info@marnova.co.id',
                'password' => 'marnova_123',
                'port' => '465',
                'encryption' => 'ssl',
                // 'host' => 'smtp.gmail.com',
                // 'username' => 'fauzimuhammad153@gmail.com',//'henry.gunawan.1986@gmail.com',
                // 'password' => 'Wonosari99',//'m26404020',
                // 'port' => '587',
                // 'encryption' => 'tls',
                'streamOptions' => [ 
                    'ssl' => [ 
                        'allow_self_signed' => true,
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                    ],
                ],
            ],
        ],
    ],
    'params' => $params,
];
