<?php 

namespace console\controllers;

use Yii;
use yii\console\Controller;
use yii\helpers\Url;
use admin\components\DeliveryCostComponent;
use common\models\Order;

class DeliveredstatusController extends Controller
{
    public function actionIndex()
    {
        date_default_timezone_set('Asia/Jakarta');

        $orders = Order::find()->andWhere('is_deleted = :is AND order_status = :status', [':is' => 0, ':status' => Order::STATUS_SENT])->all();

        foreach ($orders as $i => $item){
            
            if(!empty($item->order_receipt_number)){

                $status = DeliveryCostComponent::getDeliveredStatus($item->order_receipt_number);
                if($status){
                    $order = Order::find()->andWhere('id = :id', [':id' => $item->id])->one();
                    $order->order_status = Order::STATUS_COMPLETED;
                    $order->save();
                }
            }
        }
    }
}