<?php 

namespace console\controllers;

use Yii;
use yii\console\Controller;
use yii\helpers\Url;

use common\models\Order;
use common\models\Setting;

class ExpiredorderController extends Controller
{
    public function actionIndex()
    {
    	date_default_timezone_set('Asia/Jakarta');

        $orders = Order::find()->andWhere('is_deleted = :is AND order_status = :status', [':is' => 0, ':status' => Order::STATUS_NEW])->all();

        foreach ($orders as $i => $item){
        	$date1 = strtotime($item->created_on);
        	$date2 = strtotime(date('Y-m-d H:i:s'));

            $diff  = $date2 - $date1;
			$hours = floor($diff / (60 * 60));
			if($hours >= Setting::getSettingValueByName('real_expiry_in_hours')){
				$order = Order::find()->andWhere('id = :id', [':id' => $item->id])->one();
				$order->order_status = Order::STATUS_EXPIRED;
				if($order->save()){
                    $order->sendStockBack();
					$order->sendExpiredEmail();
				}
			}
        }
    }
}