<?php 

namespace console\controllers;

use Yii;
use yii\console\Controller;
use yii\helpers\Url;

use common\models\Order;

class ReminderpaymentController extends Controller
{
    public function actionIndex()
    {
        date_default_timezone_set('Asia/Jakarta');

        $orders = Order::find()->andWhere('is_deleted = :is AND order_status = :status AND order_payment_method = :method', [':is' => 0, ':status' => Order::STATUS_NEW, ':method' => Order::METHOD_BANKTRANSFER])->all();

        foreach ($orders as $i => $item){
            $date1 = strtotime($item->created_on);
            $date2 = strtotime(date('Y-m-d H:i:s'));

            $diff  = $date2 - $date1;
            $hours = floor($diff / (60 * 60));
            if($hours >= 2){
                $item->sendPaymentReminderEmail();
            }
        }
    }
}