<?php

use yii\db\Migration;

/**
 * Class m210217_024449_create_tbl_delivery_city
 */
class m210217_024449_create_tbl_delivery_city extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->execute("CREATE TABLE `tbl_delivery_city` (
              `id` int(11) NOT NULL,
              `city_id` int(11) NOT NULL,
              `province_id` int(11) NOT NULL,
              `city_type` varchar(255) NOT NULL,
              `city_name` varchar(255) NOT NULL,
              `city_postal_code` varchar(255) NOT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1;");

        $this->execute("ALTER TABLE `tbl_delivery_city`
              ADD PRIMARY KEY (`id`),
              ADD KEY `FK_tbl_delivery_province_tbl_delivery_city` (`province_id`);");

        $this->execute("ALTER TABLE `tbl_delivery_city`
              MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;");

        $this->execute("ALTER TABLE `tbl_delivery_city`
              ADD CONSTRAINT `FK_tbl_delivery_province_tbl_delivery_city` FOREIGN KEY (`province_id`) REFERENCES `tbl_delivery_province` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION;");
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        echo "m210217_024449_create_tbl_delivery_city cannot be reverted.\n";

        return false;
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m210217_024449_create_tbl_delivery_city cannot be reverted.\n";

        return false;
    }
    */
}
