<?php

use yii\db\Migration;

/**
 * Class m210217_024457_create_tbl_delivery_fee
 */
class m210217_024457_create_tbl_delivery_fee extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->execute("CREATE TABLE `tbl_delivery_fee` (
                  `id` int(11) NOT NULL,
                  `origin_city_id` int(11) NOT NULL,
                  `destination_city_id` int(11) NOT NULL,
                  `fee_value` decimal(20,0) NOT NULL
                ) ENGINE=InnoDB DEFAULT CHARSET=latin1;");

        $this->execute("ALTER TABLE `tbl_delivery_fee`
              ADD PRIMARY KEY (`id`),
              ADD KEY `FK_tbl_delivery_origin_tbl_delivery_city` (`origin_city_id`),
              ADD KEY `FK_tbl_delivery_destiny_tbl_delivery_city` (`destination_city_id`);");

        $this->execute("ALTER TABLE `tbl_delivery_fee`
              MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;");
        
        $this->execute("ALTER TABLE `tbl_delivery_fee`
              ADD CONSTRAINT `FK_tbl_delivery_destiny_tbl_delivery_city` FOREIGN KEY (`destination_city_id`) REFERENCES `tbl_delivery_city` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
              ADD CONSTRAINT `FK_tbl_delivery_origin_tbl_delivery_city` FOREIGN KEY (`origin_city_id`) REFERENCES `tbl_delivery_city` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION;");
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        echo "m210217_024457_create_tbl_delivery_fee cannot be reverted.\n";

        return false;
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m210217_024457_create_tbl_delivery_fee cannot be reverted.\n";

        return false;
    }
    */
}
