<?php

use yii\db\Migration;

/**
 * Class m210329_085620_create_table_tbl_voucher
 */
class m210329_085620_create_table_tbl_voucher extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
		$this->execute("CREATE TABLE `tbl_voucher` (
			`id` INT NOT NULL AUTO_INCREMENT,
			`voucher_title` VARCHAR(255) NOT NULL,
			`voucher_code` VARCHAR(255) NOT NULL,
			`voucher_from` DATETIME NULL,
			`voucher_to` DATETIME NULL,
			`voucher_type` ENUM('rupiah','percent') NOT NULL DEFAULT 'percent',
			`voucher_value` FLOAT NOT NULL,
			`voucher_min_order` DECIMAL(16,2) NULL DEFAULT NULL,
			`voucher_qty` INT NULL,
			`voucher_qty_used` INT NULL,
			PRIMARY KEY (`id`)
		)
		COLLATE='utf8mb4_general_ci'
		;");
		
		$this->execute("ALTER TABLE `tbl_order` ADD COLUMN `voucher_id` INT NULL AFTER `order_shipping_fee`, ADD COLUMN `voucher_value_rupiah` DECIMAL(16,2) NULL DEFAULT NULL AFTER `voucher_id`;");
		
		$this->execute("ALTER TABLE `tbl_order` ADD CONSTRAINT `FK_tbl_order_tbl_voucher` FOREIGN KEY (`voucher_id`) REFERENCES `tbl_voucher` (`id`) ON UPDATE NO ACTION ON DELETE NO ACTION;");
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        echo "m210329_085620_create_table_tbl_voucher cannot be reverted.\n";

        return false;
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m210329_085620_create_table_tbl_voucher cannot be reverted.\n";

        return false;
    }
    */
}
