<?php

namespace frontend\assets;

use yii\web\AssetBundle;

/**
 * Main frontend application asset bundle.
 */
class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'https://fonts.googleapis.com/css2?family=Playfair+Display:ital@0;1&display=swap',
        'css/elastislide.css',
        'css/fonts/stylesheet.css',
        'css/slick/slick.css',
        'css/slick/slick-theme.css',
        'css/site.css',
        'css/mobile.css',
    ];
    public $js = [
        'https://cdn.jsdelivr.net/npm/sweetalert2@10',
        'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js',
        'js/slick.min.js',
        'js/myjs.js'
    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\bootstrap\BootstrapAsset',
    ];
}
