<?php
namespace app\components;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\helpers\Url;
use nirvana\infinitescroll\InfiniteScrollPager;
use frontend\models\ContactForm;
use common\models\ProductCategory;

class BaseController extends Controller
{
	const SLUG_HOME = 'home';
	const SLUG_PRODUCT = 'product';
	const SLUG_INVESTOR = 'investor';

	public static $page_caption = '';
	public static $page_title = '';
	public static $page_slug = '';
	public static $site_name = 'Indonesia Food Supplier - Product - Hakiki Donarta';
	public static $toolbar = array();
	public static $breadcrumb = array();
	public static $active_page = array();
	public static $mega_categories = array();
	public static $mega_category_cols = array();

	public function init()
    {
		parent::init();
		
		self::$mega_categories = ProductCategory::find()->andWhere('is_deleted=:is AND product_category_parent_id IS NULL', [':is' => 0])->all();
		$allCategories = count(self::$mega_categories);
		self::$mega_category_cols[0] = 0;
		self::$mega_category_cols[1] = 0;
		self::$mega_category_cols[2] = 0;
		$j = 0;
		for($i = 0; $i < $allCategories; $i++) {
			self::$mega_category_cols[$j]++;
			$j++;
			if ($j > 2)
				$j = 0;
		}
    }
	
    public static function getCustomPageTitle($title = '')
	{
		self::$page_title = self::$site_name;
		if ($title != "")
			self::$page_title .= " - ".$title;

		return self::$page_title;
	}
	
	public static function setPageCaption($pageCaption)
	{
		self::$page_caption = $pageCaption;
	}
}
?>