<?php
namespace frontend\components;

use Yii;
use yii\base\Component;

class StringComponent extends Component
{
	/* truncate a long html coded text without stripping the codes */
	public static function csubstr($string, $start, $length = FALSE)
	{
		$pattern = '/(\[\w+[^\]]*?\]|\[\/\w+\]|<\w+[^>]*?>|<\/\w+>)/i';
		$clean   = preg_replace($pattern, chr(1), $string);
		if (!$length)
			$str = substr($clean, $start);
		else {
			$str = substr($clean, $start, $length);
			$str = substr($clean, $start, $length + substr_count($str, chr(1)));
		}
		$pattern = str_replace(chr(1), '(.*?)', preg_quote($str));
		if (preg_match('~' . $pattern . '~is', $string, $matched))
			return strlen($clean) > $length ? $matched[0] . " ... " : $matched[0];

		return $string;
	}
}
?>