<?php
$params = array_merge(
    require(__DIR__ . '/../../common/config/params.php'),
    require(__DIR__ . '/../../common/config/params-local.php'),
    require(__DIR__ . '/params.php'),
    require(__DIR__ . '/params-local.php')
);

use \yii\web\Request;
$baseUrl = str_replace('/frontend/web', '', (new Request)->getBaseUrl());

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

/*
if(session_id() == '') {
    session_start();
}
*/

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'frontend\controllers',
    'modules' => [
        'project' => [
            'class' => 'frontend\modules\project\Project',
        ],
    ],
    'components' => [
        'assetManager' => [
            'linkAssets' => false,
            'bundles' => [
                'yii\web\JqueryAsset' => [
                    'jsOptions' => [ 'position' => \yii\web\View::POS_HEAD ],
                ],
            ],
        ],
        'i18n' => [
            'translations' => [
                'frontend*' => [
                    'class' => 'yii\i18n\PhpMessageSource',
                    'basePath' => '@common/messages',
                    'forceTranslation' => true,
                ],
                'backend*' => [
                    'class' => 'yii\i18n\PhpMessageSource',
                    'basePath' => '@common/messages',
                    'forceTranslation' => true,
                ],
            ],
        ],
        'request' => [
            'cookieValidationKey' => '[gfhjghsdjks44fdf4fgf4fgfg5645ggxcvvc]',
            'csrfParam' => '_csrf-frontend',
            'class' => 'common\components\Request',
            'web'=> '/frontend/web',
            'enableCsrfValidation' => false
        ],
        'user' => [
            'identityClass' => 'common\models\Member',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
            //'loginUrl' => ['signin']
        ],
        'session' => [
            // this is the name of the session cookie used for login on the frontend
            'name' => 'advanced-frontend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@common/mail',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'us17.sharehostserver.com',//'newton.dnshostnetwork.com',
                'username' => 'info@marnova.co.id',
                'password' => 'marnova_123',
                'port' => '465',
                'encryption' => 'ssl',
                // 'host' => 'smtp.gmail.com',
                // 'username' => 'fauzimuhammad153@gmail.com',//'henry.gunawan.1986@gmail.com',
                // 'password' => 'Wonosari99',//'m26404020',
                // 'port' => '587',
                // 'encryption' => 'tls',
                'streamOptions' => [ 
                    'ssl' => [ 
                        'allow_self_signed' => true,
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                    ],
                ],
            ],
        ],

        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'home' => 'site/index',
                'search' => 'product/search',
                'distribution' => 'site/distribution',
                'product/<slug:[a-zA-Z0-9-]+>' => 'product/detail/',
                // 'news/getarticles' => 'news/getarticles',
                // 'news/<cat:[a-zA-Z0-9-]+>' => 'news/index',
                'news/<slug:[a-zA-Z0-9-]+>' => 'news/detail/',
                'contact' => 'site/contact',
                'search' => 'site/search',
            ],
        ],
        
    ],
    'params' => $params,
];
