<?php
namespace frontend\controllers;

use Yii;
use app\components\BaseController;
use common\models\Facility;
use common\models\Subsidiary;
use common\models\Certification;
use common\models\Brand;
use common\models\Milestone;

/**
 * About controller
 */
class AboutController extends BaseController
{
    
    public function actionIndex()
    {
        return $this->redirect(['profile']);
    }

    public function actionProfile()
    {
        BaseController::$page_caption = 'Profile';
        
        return $this->render('profile');
    }

    public function actionWhoweare()
    {
        BaseController::$page_caption = 'Who We Are';

        $subsidiaries = Subsidiary::find()->orderBy(['subsidiary_order' => SORT_ASC])->all();
        
        return $this->render('whoweare', [
            'subsidiaries' => $subsidiaries
        ]);
    }

    public function actionFacility()
    {
        BaseController::$page_caption = 'Facility & Technology';

        $facilities = Facility::find()->all();
        
        return $this->render('facility', [
            'facilities' => $facilities
        ]);
    }

    public function actionCertification()
    {
        BaseController::$page_caption = 'Facility & Technology';

        $certifications = Certification::find()->all();
        
        return $this->render('certification', [
            'certifications' => $certifications
        ]);
    }

    public function actionBrand()
    {
        BaseController::$page_caption = 'Our Brands & Principals';

        $brands = Brand::find()->all();
        
        return $this->render('brand', [
            'brands' => $brands
        ]);
    }

    public function actionMilestone()
    {
        BaseController::$page_caption = 'Our Milestone';

        $milestones = Milestone::find()->orderBy(['milestone_order' => SORT_ASC])->all();
        
        return $this->render('milestone', [
            'milestones' => $milestones
        ]);
    }
}