<?php
namespace frontend\controllers;

use Yii;
use app\components\BaseController;
use common\models\Article;
use common\models\ArticleCategory;

/**
 * News controller
 */
class NewsController extends BaseController
{
    
    public function actionIndex()
    {
        BaseController::$page_caption = 'News & Updates';

        $categories = ArticleCategory::find()->andWhere('is_deleted=:is', [':is' => 0])->all();

        $articles = Article::find()->andWhere('is_deleted=:is', [':is' => 0])->all();
        
        return $this->render('index', [
            'categories' => $categories,
            'articles' => $articles
        ]);
    }

    public function actionDetail($slug='')
    {
        $article = Article::find()->andWhere('article_slug=:slug', [':slug' => $slug])->one();

        if (empty($article)) {
            return $this->redirect(['index']);
        }

        BaseController::$page_caption = $article->article_title;
        
        return $this->render('detail', [
            'article' => $article
        ]);
    }

    public function actionGetarticles()
    {
        $articles = Article::find()->andWhere('is_deleted=:is AND article_category_id=:id', [':id' => $_POST['category_id'], ':is' => 0])->all();

        $articleArr = array();
        foreach($articles as $article) {
            $articleArr[] = [
                'article_featured_image' => Url::base(true).'/uploads/articles/'.$article->article_featured_image,
                'category_color' => $article->articleCategory->category_color,
                'category_name' => $article->articleCategory->category_name,
                'article_title' => $article->article_title,
                'article_short_description' => StringComponent::csubstr($article->article_short_description, 0, 100),
                'created_on' => date("d/m/Y", strtotime($article->created_on)),
            ];
        }

        return json_encode($articleArr);
        die();
    }
}