<?php
namespace frontend\controllers;

use Yii;
use app\components\BaseController;
use common\models\ProductCategory;
use common\models\ProductCategoryBrand;

/**
 * Product controller
 */
class ProductController extends BaseController
{
    
    public function actionIndex()
    {
        BaseController::$page_caption = 'Product';

        $categories = ProductCategory::find()->andWhere('product_category_parent_id IS NULL AND is_deleted=:is', [':is' => 0])->all();
        
        return $this->render('index', [
            'categories' => $categories
        ]);
    }

    public function actionDetail($slug='')
    {
        BaseController::$page_caption = 'Profile';

        $category = ProductCategory::find()->andWhere('product_category_slug=:slug', [':slug' => $slug])->one();

        $categories = ProductCategory::find()->andWhere('product_category_parent_id IS NULL AND is_deleted=:is', [':is' => 0])->all();

        $subCategories = ProductCategory::find()->andWhere('product_category_parent_id=:id AND is_deleted=:is', [':is' => 0, ':id' => $category->id])->all();
        $brands = [];
        foreach($subCategories as $subCategory) {
            $brands[] = ProductCategoryBrand::find()->andWhere('product_category_id=:id AND is_deleted=:is', [':is' => 0, ':id' => $subCategory->id])->all();
        }
        
        return $this->render('detail', [
            'categories' => $categories,
            'category' => $category,
            'subCategories' => $subCategories,
            'brands' => $brands,
        ]);
    }
}