<?php

namespace frontend\models;

use Yii;
use yii\base\Model;

/**
 * ChangePassForm is the model behind the change password form.
 */
class ChangePassForm extends Model
{
    public $curr_pass;
    public $new_pass;
    public $confirm_pass;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['curr_pass', 'new_pass', 'confirm_pass'], 'required'],
            [
                'confirm_pass', 'compare', 'compareAttribute' => 'new_pass',
                'message' => "Passwords don't match", 'skipOnEmpty' => false,
                'when' => function ($model) {
                    return $model->new_pass !== null && $model->new_pass !== '';
                },
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'verifyCode' => 'Verification Code',
        ];
    }

    /**
     * Sends an email to the specified email address using the information collected by this model.
     *
     * @param string $email the target email address
     * @return bool whether the email was sent
     */
    public function sendEmail($email)
    {
        return Yii::$app->mailer->compose()
            ->setTo($email)
            ->setFrom([Yii::$app->params['senderEmail'] => Yii::$app->params['senderName']])
            ->setReplyTo([$this->email => $this->name])
            ->setSubject($this->subject)
            ->setTextBody($this->body)
            ->send();
    }
}
