<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\helpers\Url;
use common\models\Setting;

/**
 * ContactForm is the model behind the contact form.
 */
class ContactForm extends Model
{
    public $name;
    public $email;
    public $subject;
    public $message;
    public $mobile_number;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'email', 'subject', 'message', 'mobile_number'], 'required'],
            ['email', 'email'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'verifyCode' => 'Verification Code',
        ];
    }

    /**
     * Sends an email to the specified email address using the information collected by this model.
     *
     * @param string $email the target email address
     * @return bool whether the email was sent
     */
    public function sendEmail()
    {
        return Yii::$app->mailer->compose()
            ->setFrom([$this->email => $this->name])
            ->setTo([Setting::getSettingValueByName('email') => 'Marnova'])
            ->setSubject($this->subject)
            ->setHtmlBody('
                <img src="'.Url::base(true).'/img/logo.jpg" alt="Marnova" />
                <br/>
                <p>We\'ve got a new question here.</p>
                <p>
                    <b>Name</b><br/>
                    '.$this->name.'
                </p>
                <p>
                    <b>Phone</b><br/>
                    '.$this->mobile_number.'
                </p>
                <p>
                    <b>Email</b><br/>
                    '.$this->email.'
                </p>
                <p>
                    <b>Message</b><br/>
                    '.nl2br($this->message).'
                </p>
            ')
            ->send();
    }
}
