<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\helpers\Url;
use common\models\Setting;

/**
 * ForgetPasswordForm is the model behind the change password form.
 */
class ForgetPasswordForm extends Model
{
    public $email;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['email'], 'required'],
            [['email'], 'email'],
        ];
    }

    /**
     * Sends an email to the specified email address using the information collected by this model.
     *
     * @param string $email the target email address
     * @return bool whether the email was sent
     */
    public function sendResetPassLink($member)
    {
        return Yii::$app->mailer->compose()
            ->setFrom([Setting::getSettingValueByName('from_email') => Setting::getSettingValueByName('from_name')])
            ->setTo([$member->member_email => $member->member_fullname])
            ->setSubject("Reset Password")
            ->setHtmlBody('
                <img src="'.Url::base(true).'/img/logo.jpg" alt="Marnova" />
                <br/>
                <p>Dear '.$member->member_fullname.',</p>
                <p>You have sent a request for resetting your password. Please click the link below to go to reset password page:</p>
                <p><a href="'.Url::base(true).'/resetpassword/'.$member->member_password_reset_token.'">'.Url::base(true).'/resetpassword/'.$member->member_password_reset_token.'</a></p>
                <p>If you didn\'t send a request for resetting password, please ignore this message or contact us for help.</p>
                <br/>
                <p>
                    Marnova Customer Service Team<br/>
                    Email: info@marnova.co.id<br/>
                    WhatsApp: +62857 4143 442 / +62858 8865 7611<br/>
                    Follow our updates on instagram @marnovacloset
                </p>
            ')
            ->send();
    }
}
