<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use common\models\Member;

/**
 * LoginForm is the model behind the login form.
 */
class LoginForm extends Model
{
    public $email;
    public $password;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['email', 'password'], 'required'],
            ['email', 'email'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'email' => 'Email',
            'password' => 'Password',
        ];
    }

    /**
     * Sends an email to the specified email address using the information collected by this model.
     *
     * @param string $email the target email address
     * @return bool whether the email was sent
     */
    public function login()
    {
        $member = Member::find()->andWhere('member_status<>:status AND is_deleted=:is AND member_email=:email', [':email' => $this->email, ':is' => 0, ':status' => Member::STATUS_BLACKLIST])->one();

        if (empty($member)) {
            return [
                'status' => false,
                'errorCode' => 1,
            ];
        } else {
            if (!Yii::$app->security->validatePassword($this->password, $member->member_password)) {
                return [
                    'status' => false,
                    'errorCode' => 2,
                ];
            }
        }

        return [
            'status' => true,
            'data' => $member
        ];
    }

    public function login2()
    {
        $member = Member::find()->andWhere('member_status<>:status AND is_deleted=:is AND member_email=:email AND member_password=:pass', [':email' => $this->email, ':is' => 0, ':status' => Member::STATUS_BLACKLIST, ':pass' => $this->password])->one();
        if (empty($member)) {
            return [
                'status' => false,
                'message' => "Wrong username or password",
            ];
        }

        return [
            'status' => true,
            'data' => $member
        ];
    }
}
