<?php

namespace frontend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Order;

/**
 * OrderSearch represents the model behind the search form of `common\models\Order`.
 */
class OrderSearch extends Order
{
    public $member_fullname, $start_date, $end_date, $sipto;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'member_id', 'order_recipient_province_id', 'order_recipient_city_id', 'created_by', 'updated_by', 'is_deleted'], 'integer'],
            [['order_code', 'order_date', 'order_recipient_fullname', 'order_recipient_address', 'order_recipient_province_name', 'order_recipient_city_name', 'order_recipient_phone', 'order_recipient_email', 'order_payment_method', 'order_status', 'created_on', 'updated_on', 'member_fullname', 'start_date', 'end_date', 'sipto'], 'safe'],
            [['order_subtotal', 'order_shipping_fee', 'order_grand_total'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Order::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 10,
            ],
            'sort'=> [
                'attributes' => [
                    'order_code',
                    'order_date',
                    'order_grand_total',
                    'order_status',
                ],
                'defaultOrder' => ['order_date' => SORT_DESC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'member_id' => $this->member_id,
            'order_grand_total' => $this->order_grand_total,
            'is_deleted' => 0,
        ]);

        $query->andFilterWhere(['like', 'order_code', $this->order_code])
            ->andFilterWhere(['like', 'order_status', $this->order_status]);

        if ($this->start_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date))
            $query->andWhere('DATE(order_date) >= "'.date("Y-m-d", strtotime($this->start_date)).'"');
        if ($this->end_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date))
            $query->andWhere('DATE(order_date) <= "'.date("Y-m-d", strtotime($this->end_date)).'"');

        return $dataProvider;
    }
}
