<?php
namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\helpers\Url;
use common\models\User;
use common\models\Member;
use common\models\Setting;

/**
 * Signup form
 */
class SignupForm extends Model
{
    public $member_fullname;
    public $member_email;
    public $password;
    public $confirm;


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            ['member_fullname', 'required'],

            ['member_email', 'trim'],
            ['member_email', 'required'],
            ['member_email', 'email'],
            ['member_email', 'string', 'max' => 255],
            ['member_email', 'unique', 'targetClass' => '\common\models\Member', 'message' => 'This email address has already been taken.'],

            ['password', 'required'],
            ['password', 'string', 'min' => Yii::$app->params['user.passwordMinLength']],

            [
                'confirm', 'compare', 'compareAttribute' => 'password',
                'message' => "Passwords don't match", 'skipOnEmpty' => false,
                'when' => function ($model) {
                    return $model->password !== null && $model->password !== '';
                },
            ],
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $member = new Member();
        $member->member_fullname = $this->member_fullname;
        $member->member_email = preg_replace('/\s+/', '', $this->member_email);
        $member->setPassword($this->password);
        $member->generatEemailVerificationToken();
        
        return $member->save();// && $this->sendmember_email($user);

    }

    public function sendVerificationEmail($member)
    {
        return Yii::$app->mailer->compose()
            // ->setFrom(['henry.gunawan.1986@gmail.com' => 'Henry Gunawan'])
            ->setTo([Setting::getSettingValueByName('email') => 'Marnova'])
            ->setTo([$member->member_email => $member->member_fullname])
            ->setSubject("Please verify your email.")
            ->setHtmlBody('
                <img src="'.Url::base(true).'/img/logo.jpg" alt="Marnova" />
                <br/>
                <p>Dear '.$member->member_fullname.',</p>
                <p>Thank you for creating Marnova account.</p>
                <p>Please visit the link below to verify your email address and complete your registration.</p>
                <p><a href="'.Url::base(true).'/verify/'.$member->member_verification_code.'">'.Url::base(true).'/verify/'.$member->member_verification_code.'</a></p>
                <br/>
                <p>
                    Marnova Customer Service Team<br/>
                    Email: info@marnova.co.id<br/>
                    WhatsApp: +62857 4143 442 / +62858 8865 7611<br/>
                    Follow our updates on instagram @marnovacloset
                </p>
            ')
            ->send();
    }
}
