<?php
use yii\helpers\Url;
use common\components\CurrencyComponent;
?>


<a href="<?=Url::base(true)?>/product/detail/<?=$model->product_slug?>">
	<?php 
		$urlImg = !empty($model->getDefaultImage()->product_image_filename) ? Url::base(true).'/uploads/products/'.$model->getDefaultImage()->product_image_filename : Url::base(true).'/img/no-image.png';
	?>
	<div class="product-item-image" style="background-image: url('<?=$urlImg?>')">
	
	</div>
	<div class="product-item-name"><?=$model->product_name?></div>
	<div class="product-item-price <?=!empty($model->product_sale_price) ? "onsale" : ""?>">
		<?=CurrencyComponent::formatMoney($model->product_price, 'IDR ')?>
	</div>
	<?php if (!empty($model->product_sale_price)):?>
	<div class="product-item-sale-price"><?=CurrencyComponent::formatMoney($model->product_sale_price, 'IDR ')?></div>
	<?php endif;?>
</a>
