<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-brand">
	<h1>Delivering Our Very Best</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-principal">
	<div class="inline-container">
        <div class="section-title">Our Brand and Principals</div>
		<div class="section-content">
			<div class="principal-container">
				<div class="principal-col-left"><img src="<?=Url::base(true)?>/img/about-brand1.jpg" alt="" /></div>
				<div class="principal-col-right">
					<div class="principal-border border-top"></div>
					<div class="green-decor"></div>
					<div class="principal-desc-wrapper">
						<div class="principal-title">COMMITED IN HEART AND MIND</div>
						<div class="principal-desc">We always try to keep updated on the latest technology. Our main focus as a corporation is not solely on profit alone but also on how to grow with this ever-expanding business and technology.</div>
					</div>
					<div class="principal-border border-bottom"></div>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>

<div class="section most-bottom-section" id="section-brand">
	<div class="inline-container">
		<div class="section-title">DISCOVER OUR BRANDS</div>
		<div class="section-content">
			<div class="brand-container">
			<?php foreach($brands as $i => 	$brand):?>
				<div class="brand-item <?=($i+1)%2 == 0 ? 'even' : 'odd'?>">
					<div class="brand-logo">
						<img src="<?=Url::base(true)?>/uploads/brands/<?=$brand->brand_logo?>" alt="" />
					</div>
				</div>
				<?php if (($i) % 2 == 1):?>
				<div class="clear clear-2"></div>
				<?php endif;?>
				<?php if ($i % 4 == 3 || $i == count($brands)-1):?>
				<div class="clear"></div>
				<?php endif;?>
			<?php endforeach;?>
			</div>
		</div>
	</div>
</div>