<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-certification">
	<h1>Satisfaction Guaranteed</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-standard">
	<div class="inline-container">
        <div class="section-title">Standard & Certification</div>
		<div class="section-content">
			<div class="standard-container">
				<div class="standard-col-left"><img src="<?=Url::base(true)?>/img/about-certification1.jpg" alt="" /></div>
				<div class="standard-col-right">
					<div class="standard-border border-top"></div>
					<div class="green-decor"></div>
					<div class="standard-desc-wrapper">
						<div class="standard-title">IMPROVE THE QUALITY MANAGEMENT SYSTEM</div>
						<div class="standard-desc">All those certification are only possible because Hakiki Donarta is made by dedicated team who work in sync to strengthen our main goal : to becoming the most prefered food and beverage ingredients supplier in Indonesia</div>
					</div>
					<div class="standard-border border-bottom"></div>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>

<div class="section most-bottom-section" id="section-certification">
	<div class="inline-container">
		<div class="highlight">Commit on high standards in every products and services also managing our business is completed with our certification in food safety and quality, namely; ISO, BPOM, FOODGRADE, USFDA, also HALAL certified in all of our products.</div>
		<div class="section-content">
			<fieldset>
				<legend>DISCOVER OUR CERTIFICATION</legend>
				<div class="inline-container">
					<div class="certification-container">
					<?php foreach($certifications as $i => $certification):?>
						<div class="certification-item <?=($i+1) % 2 == 0 ? 'even-item' : 'odd-item'?> <?=$i % 3 == 2 ? 'last-item' : ''?>">
							<div class="certification-logo"><img src="<?=Url::base(true)?>/uploads/certifications/<?=$certification->certification_logo?>" alt="" /></div>
							<div class="certification-name"><?=$certification->certification_name?></div>
						</div>
						<?php if ($i % 2 == 1):?>
							<div class="clear clear-2"></div>
						<?php endif;?>
						<?php if ($i % 3 == 2):?>
						<div class="clear clear-3"></div>
						<?php endif;?>
					<?php endforeach;?>
					</div>
				</div>
			</fieldset>
		</div>
	</div>
</div>