<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-facility">
	<h1>Pushing Limits</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-facility-intro">
    <div class="inline-container">
        <div class="section-title">Facility & Technology</div>
		<div class="section-content">
			<div class="facility-intro-container">
				<div class="facility-intro-col-left"><img src="<?=Url::base(true)?>/img/about-facility1.jpg" alt="" /></div>
				<div class="facility-intro-col-right">
					<div class="facility-intro-border border-top"></div>
					<div class="brown-decor"></div>
					<div class="facility-intro-desc-wrapper">
						<div class="facility-intro-title">TECHNOLOGY OPERATED BY HUMAN RESOURCE</div>
						<div class="facility-intro-desc">We always try to update the latest technology. Technology is operated by growing human resources. The latest technology supports innovation.</div>
					</div>
					<div class="facility-intro-border border-bottom"></div>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>

<div class="section most-bottom-section" id="section-facilities">
    <div class="inline-container">
        <div class="section-title">Discover Our Facilities</div>
		<div class="section-content">
			<div class="facilities-accordion">
			<?php foreach($facilities as $facility):?>
				<div class="accordion-item" id="accordion-item-<?=$facility->id?>">
					<div class="accordion-header"><?=$facility->facility_title?></div>
					<div class="accordion-body"><?=$facility->facility_desc?></div>
				</div>
			<?php endforeach;?>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript">
$(document).ready(function(){
	$('.accordion-item').click(function(){
		// var header = $(this).find('.accordion-header');
		var body = $(this).find('.accordion-body');
		if ($(this).hasClass('active')) {
			$(this).removeClass('active');
			body.stop().slideUp();
		} else {
			$(this).addClass('active');
			body.stop().slideDown();
		}
	});
});
</script>