<?php
use yii\helpers\Url;
use app\components\BaseController;
use common\models\Milestone;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-milestone">
	<h1>Endless Journey to Goodness</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-milestone">
    <div class="inline-container">
        <div class="section-title">Our Milestone</div>
    </div>
    <div class="section-content">
        <div class="milestone-container">
            <div class="milestone-left">
            <?php foreach($milestones as $i => $milestone):?>
                <?php if ($milestone->milestone_position == Milestone::POSITION_LEFT):?>
                    <div class="milestone-item" id="milestone-item-left-<?=($i+1)?>">
                        <img src="<?=Url::base(true)?>/uploads/milestones/<?=$milestone->milestone_image?>" alt="" />
                        <div class="milestone-marker-outer">
                            <div class="milestone-marker">
                                <div class="milestone-active"></div>
                            </div>
                        </div>
                    </div>
                <?php else:?>
                    <div class="milestone-item" id="milestone-item-left-<?=($i+1)?>">
                        <div class="milestone-desc-wrapper">
                            <div class="milestone-year"><?=$milestone->milestone_year;?></div>
                            <div class="milestone-desc"><?=$milestone->milestone_description;?></div>
                        </div>
                        <div class="milestone-marker-outer">
                            <div class="milestone-marker">
                                <div class="milestone-active"></div>
                            </div>
                        </div>
                    </div>
                <?php endif;?>
            <?php endforeach;?>
            </div>
            <div class="milestone-right">
            <?php foreach($milestones as $i => $milestone):?>
                <?php if ($milestone->milestone_position == Milestone::POSITION_LEFT):?>
                <div class="milestone-item " id="milestone-item-right-<?=($i+1)?>">
                    <div class="milestone-desc-wrapper">
                        <div class="milestone-year"><?=$milestone->milestone_year;?></div>
                        <div class="milestone-desc"><?=$milestone->milestone_description;?></div>
                    </div>
                </div>
                <?php else:?>
                <div class="milestone-item" id="milestone-item-right-<?=($i+1)?>">
                    <img src="<?=Url::base(true)?>/uploads/milestones/<?=$milestone->milestone_image?>" alt="" />
                </div>
                <?php endif;?>
            <?php endforeach;?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>
<div class="section most-bottom-section" id="section-milestone-mobile">
    <div class="inline-container">
        <div class="section-title">Our Milestone</div>
    </div>
    <div class="section-content">
        <div class="milestone-container">
        <?php foreach($milestones as $i => $milestone):?>
            <div class="milestone-item <?=($i+1)%2 == 0 ? 'even' : 'odd'?>">
                <img src="<?=Url::base(true)?>/uploads/milestones/<?=$milestone->milestone_image?>" alt="" />
                <div class="milestone-year"><?=$milestone->milestone_year;?></div>
                <div class="milestone-desc"><?=$milestone->milestone_description;?></div>
            </div>
        <?php endforeach;?>
        </div>
    </div>
</div>
<script type="text/javascript">
$(window).on('scroll', function(){
    $(".milestone-item").each(function(i){
        if ($(window).scrollTop() >= ($(this).offset().top - ($(window).height() / 1.5))) {
            $(this).find(".milestone-active").fadeIn();
        } else {
            $(this).find(".milestone-active").fadeOut();
        }
    });
});
</script>