<?php
use yii\widgets\ListView;
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section" id="section-category-list">
	<div class="section-title"><span>SALE</span></div>
	<div class="section-content">
		<div class="inline-container">
		<?=ListView::widget([
			    'dataProvider' => $dataProvider,
			    'options' => [
			        'tag' => 'div',
			        'class' => 'product-list-wrapper',
			        'id' => 'product-list-wrapper',
			    ],
			    'itemOptions' => [
		    		'tag' => 'div',
		    		'class' => 'product-item',
		    	],
			    'layout' => "{items}\n{pager}",
			    'itemView' => '_product',
			    'pager' => [
			        'nextPageLabel' => '<img src="'.Url::base(true).'/img/slide-arrow-right.png" alt="" />',
			        'prevPageLabel' => '<img src="'.Url::base(true).'/img/slide-arrow-left.png" alt="" />',
			        'maxButtonCount' => 0,
			    ],
			]);
		?>
		</div>
	</div>
</div>