<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-about">
	<h1>Create, Inspire, Innovate</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-who-we-are">
    <div class="inline-container">
        <div class="section-title">Who We Are</div>
        <div class="section-content">
            <div class="col-right">
                <img src="<?=Url::base(true)?>/img/hakiki-founder.png" alt="" />
            </div>
            <div class="col-left">
                <p>From the stall in the area of Chinatown in Surabaya, Hakiki continue to expand into a holding company with a couple of food, beverage and pharmaceautical ingredients manufacturing facilities supporting the domestic as well as International market.</p>
                <p class="highlight">
                    In 1969, Mr Tjan Thian Hok, being the founder of the company set up the shop merchandising staple ingredient as sugar, rice, coffee, sweets and confectioneries. Implementing the 3 pillars of the family philosophies:
                </p>
                <ol class="highlight">
                    <li>Respect</li>
                    <li>Fulfil Promise</li>
                    <li>Continuous Learning</li>
                </ol>
                <p>Hakiki, in Sanskrit meaning The Truth, gain its reputable name through times. By 1976, Mr Sindunata Sambudhi, as the next generation wisely chose to focus the business into bakery ingredient. This choice was due to the reason that Indonesia had the world's largest flour mill processing plant. Wheat flour value chain were not so far away from bread and butter.</p>
                <p>By 1992, the shop escalated another level being Private Limited Company that was the beginning of a quantum leap to the Hakiki holding activities. Many international brands were trusted to Hakiki for distribution and exclusivity. Customer segmentation grows from housewives, retail shops into hotel, bakery, restaurants, food beverage and pharmaceautical industries. Human resource was then the challenge.</p>
                <p>To streamline its business activities being importer, distributor and Manufacturing, Hakiki implemented Enterprise Resource Planning (ERP) system in 2004. Performance indicator was introduced as a tool to measure the performance.</p>
                <p>In 2004, PT Landkrone Indo Nutri, specialist in oil and fats production is another flagship portfolio of Hakiki Holding. The primary focus of developing oil and fats is to be an innovative premium product giving healthier choice at an affordable value. The tagline “Karya Anak Bangsa” meaning “Proudly Indonesian” is to encourage consumer to be proud using local product with International Quality Standard.</p>
                <p>Today Hakiki Donarta Holdings owns state of the art Agar-Agar production to cater for the Worlds expectation, implementing The Blue Economy philosophy, BRC (British Retail Consortium) certification and meeting the dynamic modern consumer’s demand by introducing Gracilaria based organic Agar-agar, and more innovative product in the future. The value chain impact from processing seaweed into food has given positive economic return in the rural areas for sustainable livelihood.</p>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>

<div class="section" id="section-subsidiaries">
    <div class="inline-container">
        <fieldset>
			<legend>PT HAKIKI DONARTA HAS NOW <?=count($subsidiaries)?> SUPPORTING<br/>SUBSIDIARIES, NAMELY:</legend>
			<div class="inline-container">
            <?php foreach($subsidiaries as $i => $subsidiary):?>
                <div class="subsidiary-item <?=$i % 3 == 0 ? 'subsidiary-most-left' : '' ?>">
                    <div class="subsidiary-item-inner">
                        <div class="subsidiary-title"><?=$subsidiary->subsidiary_name?></div>
                        <div class="subsidiary-desc"><?=$subsidiary->subsidiary_desc?></div>
                    </div>
                </div>
                <?php if($i % 3 == 2 || $i == count($subsidiaries) - 1):?>
                <div class="clear"></div>
                <?php endif;?>
            <?php endforeach;?>
			</div>
		</fieldset>
    </div>
</div>

<div class="section most-bottom-section" id="section-vision-mission">
    <div class="inline-container">
        <h2 class="section-title2">Vision & Mission</h2>
        <div class="highlight">BECOME PRODUCER AND DISTRIBUTOR OF HIGH QUALITY, SAFE AND INNOVATIVE FOOD INGREDIENTS THROUGH BEST SERVICE AND KEEP DEVELOPING POTENTIAL HUMAN RESOURCE WITH FACING THE CURRENTS DEVELOPMENT INNOVATIVELY</div>
        <div class="feature-container">
            <div class="feature-item">
                <div class="feature-image"><img src="<?=Url::base(true)?>/img/icon-innovation.png" alt="" /></div>
                <div class="feature-title">INNOVATION</div>
                <div class="feature-desc">Develop a variety of products to meet consumer needs.</div>
            </div>
            <div class="feature-item">
                <div class="feature-image"><img src="<?=Url::base(true)?>/img/icon-food-safety.png" alt="" /></div>
                <div class="feature-title">FOOD SAFETY</div>
                <div class="feature-desc">We want consumers to be confident that our products are safe for them and their families, and better for the environment.</div>
            </div>
            <div class="clear clear-2"></div>
            <div class="feature-item">
                <div class="feature-image"><img src="<?=Url::base(true)?>/img/icon-halal.png" alt="" /></div>
                <div class="feature-title">HALAL PRODUCT</div>
                <div class="feature-desc">Products that have Halal certification and are safe to use at any time.</div>
            </div>
            <div class="feature-item">
                <div class="feature-image"><img src="<?=Url::base(true)?>/img/icon-consistent.png" alt="" /></div>
                <div class="feature-title">CONSISTENT QUALITY</div>
                <div class="feature-desc">The products produced are quality, safe and innovative as the times develop.</div>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>