<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Url;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use common\models\Setting;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="Description" content="<?=Setting::getSettingValueByName("meta_description")?>">
    <meta property="og:title" content="Hakiki Donarta">
    <meta property="og:description" content="<?=Setting::getSettingValueByName("meta_description")?>">
    <meta property="og:url" content="<?=Url::canonical()?>">
    <meta property="og:image" content="<?=Url::base(true)?>/img/logo.png">
    <?php $this->registerCsrfMetaTags() ?>
    <link rel="preconnect" href="https://fonts.gstatic.com">

    <link rel="apple-touch-icon" sizes="57x57" href="<?=Url::base(true)?>/img/favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?=Url::base(true)?>/img/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?=Url::base(true)?>/img/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?=Url::base(true)?>/img/favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?=Url::base(true)?>/img/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?=Url::base(true)?>/img/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?=Url::base(true)?>/img/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?=Url::base(true)?>/img/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?=Url::base(true)?>/img/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?=Url::base(true)?>/img/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?=Url::base(true)?>/img/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?=Url::base(true)?>/img/favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?=Url::base(true)?>/img/favicon/favicon-16x16.png">
    <link rel="manifest" href="<?=Url::base(true)?>/img/favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?=Url::base(true)?>/img/favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

    <title><?= Html::encode($this->title) ?></title>

    <script type="text/javascript">
        var baseUrl = "<?=Url::base(true)?>";
    </script>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>
<div id="header-fixed"><?php echo Yii::$app->view->render('parts/headerfixed');?></div>
<div id="navigation-mobile-wrapper"><?php echo Yii::$app->view->render('parts/navmobile');?></div>
<div class="sub-nav-mobile-wrapper" id="sub-nav-about"><?php echo Yii::$app->view->render('parts/subnavabout');?></div>
<div class="sub-nav-mobile-wrapper" id="sub-nav-product"><?php echo Yii::$app->view->render('parts/subnavproduct');?></div>
<div id="wrap">
    <div id="wrap-inside">
        <div id="header"><?php echo Yii::$app->view->render('parts/header');?></div>
        <div id="main">
            <?=$content?>
        </div>
    </div>
</div>
<div id="footer"><?php echo Yii::$app->view->render('parts/footer');?></div>
<div id="copyright"><?php echo Yii::$app->view->render('parts/copyright');?></div>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
