<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Setting;
use app\components\BaseController;
?>
<div class="header-top">
	<div class="header-top-decoration"></div>
</div>
<div class="inline-container">
	<div class="header-logo-wrapper">
		<div class="logo">
			<a href="<?=Url::base(true)?>">
				<img src="<?=Url::base(true)?>/img/logo.png" alt="" />
			</a>
		</div>
		<div class="social-media-wrapper">
			<a target="_blank" href="<?=Setting::getSettingValueByName('linkedin_url')?>">
				<div class="social-media-item" id="social-linkedin"></div>
			</a>
			<a target="_blank" href="<?=Setting::getSettingValueByName('instagram_url')?>">
				<div class="social-media-item" id="social-instagram"></div>
			</a>
			<a target="_blank" href="<?=Setting::getSettingValueByName('facebook_url')?>">
				<div class="social-media-item" id="social-facebook"></div>
			</a>
			<a href="#">
				<div class="social-media-item" id="social-contact"></div>
			</a>
		</div>
		<div class="burger-menu"></div>
	</div>
	<div class="search-textinput-container">
		<?php $form = ActiveForm::begin(['id' => 'search-form', 'enableClientValidation' => false, 'method' => 'get', 'action' => Url::base(true)."/search"]); ?>
			<?=Html::textInput('keyword', isset($_GET['keyword']) ? $_GET['keyword'] : "", ['placeholder' => 'Type in here', 'class' => 'text-search'])?>
		<?php ActiveForm::end(); ?>
		<div class="close-search-icon"></div>
	</div>
	<div class="navigation-wrapper">
		<ul>
			<li>
				<a href="<?=Url::base(true)?>">HOME</a>
			</li>
			<li id="nav-about">
				<a href="<?=Url::base(true)?>/about">ABOUT</a>
				<div class="nav-mega-menu" id="mega-about">
					<div class="mega-menu-title">
						<h3>ABOUT</h3>
						<img src="<?=Url::base(true)?>/img/mega-menu-about-img.png" alt="" />
					</div>
					<div class="mega-menu-nav-wrapper">
						<div class="mega-menu-nav-item-col">
							<a href="<?=Url::base(true)?>/about/whoweare">
								<div class="mega-menu-nav-item">
									Who We Are <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
							<a href="<?=Url::base(true)?>/about/facility">
								<div class="mega-menu-nav-item">
									Facility & Technology <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						</div>
						<div class="mega-menu-nav-item-col">
							<a href="<?=Url::base(true)?>/about/milestone">
								<div class="mega-menu-nav-item">
									Our Milestone <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
							<a href="<?=Url::base(true)?>/about/certification">
								<div class="mega-menu-nav-item">
									Standard & Certification <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						</div>
						<div class="mega-menu-nav-item-col mega-menu-last-col">
							<a href="<?=Url::base(true)?>/about/brand">
								<div class="mega-menu-nav-item">
									Our Brand & Principals <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						</div>
						<div class="clear"></div>
					</div>
				</div>
			</li>
			<li id="nav-product">
				<a href="<?=Url::base(true)?>/product">OUR PRODUCT</a>
				<div class="nav-mega-menu" id="mega-product">
					<div class="mega-menu-title">
						<h3>OUR PRODUCT</h3>
						<img src="<?=Url::base(true)?>/img/mega-menu-product-img.png" alt="" />
					</div>
					<div class="mega-menu-nav-wrapper">
						<div class="mega-menu-nav-item-col">
						<?php for($i = 0; $i < BaseController::$mega_category_cols[0]; $i++):?>
							<a href="<?=Url::base(true)?>/product/<?=BaseController::$mega_categories[$i]->product_category_slug?>">
								<div class="mega-menu-nav-item">
									<?=BaseController::$mega_categories[$i]->product_category_name?> <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						<?php endfor;?>
						</div>
						<div class="mega-menu-nav-item-col">
						<?php for($i = BaseController::$mega_category_cols[0]; $i < (BaseController::$mega_category_cols[0] + BaseController::$mega_category_cols[1]); $i++):?>
							<a href="<?=Url::base(true)?>/product/<?=BaseController::$mega_categories[$i]->product_category_slug?>">
								<div class="mega-menu-nav-item">
									<?=BaseController::$mega_categories[$i]->product_category_name?> <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						<?php endfor;?>
						</div>
						<div class="mega-menu-nav-item-col mega-menu-last-col">
						<?php for($i = BaseController::$mega_category_cols[0] + BaseController::$mega_category_cols[1]; $i < count(BaseController::$mega_categories); $i++):?>
							<a href="<?=Url::base(true)?>/product/<?=BaseController::$mega_categories[$i]->product_category_slug?>">
								<div class="mega-menu-nav-item">
									<?=BaseController::$mega_categories[$i]->product_category_name?> <img class="mega-menu-hover-icon" src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
								</div>
							</a>
						<?php endfor;?>
						</div>
						<div class="clear"></div>
					</div>
				</div>
			</li>
			<li>
				<a href="<?=Url::base(true)?>/distribution">OUR DISTRIBUTION</a>
			</li>
			<li>
				<a href="<?=Url::base(true)?>/news">NEWS & UPDATE</a>
			</li>
			<li>
				<a href="https://produkhakiki.com/">ONLINE CATALOGUE</a>
			</li>
			<li>
				<a href="<?=Url::base(true)?>/contact">CONTACT</a>
			</li>
		</ul>
		<div class="clear"></div>
		<div class="search-button"></div>
	</div>
</div>