<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Category;
use common\models\Setting;
?>
<div class="navigation-panel-inner">
	<div class="btn-mobile-icon"></div>
	<div class="search-container-mobile">
		<?php $form = ActiveForm::begin(['id' => 'search-form-mobile', 'enableClientValidation' => false, 'method' => 'get', 'action' => Url::base(true)."/search"]); ?>
			<button type="submit" class="button-search">&nbsp;</button>
			<?=Html::textInput('keyword', isset($_GET['keyword']) ? $_GET['keyword'] : "", ['class' => 'text-search'])?>
		<?php ActiveForm::end(); ?>
	</div>
	<div class="navigation-item-container">
		<ul>
			<li><a href="<?=Url::base(true)?>/product/newarrival">NEW ARRIVALS</a></li>
			<?php $categories = Category::find()->andWhere('is_deleted=:is', [':is' => 0])->all();?>
			<?php foreach($categories as $category):?>
			<li><a href="<?=Url::base(true)?>/product/<?=$category->category_slug?>"><?=$category->category_name?></a></li>
			<?php endforeach;?>
			<li><a href="<?=Url::base(true)?>/product/sale">SALE</a></li>
			<li>&nbsp;</li>
			<?php if (!isset($_SESSION['member_id']) || empty($_SESSION['member_id'])):?>
			<li><a href="<?=Url::base(true)?>/login">SIGN IN</a></li>
			<?php else:?>
			<li><a href="<?=Url::base(true)?>/myaccount">MY ACCOUNT</a></li>
			<?php endif;?>
			<li><a href="<?=Url::base(true)?>/order/confirmpayment">CONFIRM PAYMENT</a></li>
			<li><a href="<?=Url::base(true)?>/orderandpayment">ORDER & PAYMENT</a></li>
			<li><a href="<?=Url::base(true)?>/faq">FAQS</a></li>
			<li><a href="<?=Url::base(true)?>/contact">CONTACT US</a></li>
			<?php if (isset($_SESSION['member_id']) && !empty($_SESSION['member_id'])):?>
			<li><a href="<?=Url::base(true)?>/logout">LOG OUT</a></li>
			<?php endif;?>
		</ul>
	</div>
	<div class="whatsapp-box-mobile">
		<a href="https://api.whatsapp.com/send?phone=<?=Setting::getSettingValueByName('whatsapp_number_link')?>&text=Halo%20Marnova" target="_blank">
			<div class="whatsapp-icon"><img src="<?=Url::base(true)?>/img/icon-wa-footer.png" alt="" /></div>
			<div class="whatsapp-desc">Need Assistance?<br/>Chat on Whatsapp</div>
			<div class="clear"></div>
		</a>
	</div>
	<div class="clear"></div>
</div>