<?php
use yii\helpers\Url;
use app\components\BaseController;
use frontend\components\StringComponent;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-news">
	<h1>Latest Update</h1>
	<div class="banner-line"></div>
</div>

<div class="section most-bottom-section" id="section-article-filter">
	<div class="inline-container">
		<h2 class="section-title2"><?=$article->article_title?></h2>
        <div class="date-social-media-wrapper">
            <div class="article-date"><?=date("d F Y", strtotime($article->created_on))?></div>
            <div class="article-social-media-wrapper">
                Share
                <img src="<?=Url::base(true)?>/img/icon-linkedin-share.png" alt="" />
                <img src="<?=Url::base(true)?>/img/icon-facebook-share.png" alt="" />
                <img src="<?=Url::base(true)?>/img/icon-twitter-share.png" alt="" />
            </div>
            <div class="clear"></div>
        </div>
        <div class="article-image"><img src="<?=Url::base(true)?>/uploads/articles/<?=$article->article_featured_image?>" alt="" /></div>
        <div class="article-content"><?=$article->article_description?></div>
        <div class="back-to-news-button hakiki-style-button">
            <a href="<?=Url::base(true)?>/news">
                <div class="hakiki-style-button-inner">
                    <div class="button-icon"><img src="<?=Url::base(true)?>/img/icon-back-to-news.png" alt=""></div>
                    <div class="button-text">Back To News</div>
                </div>
            </a>
        </div>
    </div>
</div>