<?php
use yii\helpers\Url;
use app\components\BaseController;
use frontend\components\StringComponent;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-news">
	<h1>Latest Update</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-article-filter">
	<div class="inline-container">
		<h2 class="section-title2">Event & News</h2>
        <div class="article-category-container">
            <div class="article-category-item active" id="article-category-item-all">
                <div class="article-category-image"><img src="<?=Url::base(true)?>/img/icon-article-cat-all.png" alt="" /></div>
                <div class="article-category-name">ALL <div class="icon-arrow-orange"></div></div>
            </div>
        <?php foreach($categories as $i => $category):?>
            <div class="article-category-item" id="article-category-item-<?=$category->id?>">
                <div class="article-category-image"><img src="<?=Url::base(true)?>/uploads/articlecategories/<?=$category->category_image?>" alt="" /></div>
                <div class="article-category-name"><?=$category->category_name?> <div class="icon-arrow-orange"></div></div>
            </div>
        <?php endforeach;?>
            <div class="clear"></div>
        </div>
        <div class="article-category-filter-wrapper">
            <div class="inline-container">
                <div class="article-category-dropdown-wrapper">
                    <div class="filter-title">FILTER BY CATEGORY</div>
                    <select id="dropdown-category-filter">
                        <option value=''>Show All</option>
                        <?php foreach($categories as $i => $category):?>
                        <option value=".cat-<?=$category->id?>"><?=$category->category_name?></option>
                        <?php endforeach;?>
                    </select>
                </div>
                <div class="filter-by-year">
                    <div class="filter-title">FILTER BY YEAR</div>
                    <select id="dropdown-year-filter">
                        <option value=''>Show All</option>
                    <?php for($i=date("Y"); $i>date("Y")-10;$i--):?>
                        <option value=".year-<?=$i?>"><?=$i?></option>
                    <?php endfor;?>
                    </select>
                </div>
                <div class="search-article-wrapper">
                    <div class="filter-title">SEARCH NEWS</div>
                    <div class="search-article-button-wrapper">
                        <div class="search-article-button"><img src="<?=Url::base(true)?>/img/icon-search-white.png" alt="" /></div>
                    </div>
                    <div class="search-article-textinput">
                        <input type="text" name="text-search" id="text-search" placeholder="Search News, Event or Article Names"/>
                    </div>
                    <div class="clear"></div>
                </div>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>
<div class="section most-bottom-section" id="section-articles">
    <div class="inline-container">
        <div class="section-content">
            <div class="article-container">
            <?php foreach($articles as $i => $article):?>
                <a href="<?=Url::base(true)?>/news/<?=$article->article_slug?>">
                    <div class="news-item cat-<?=$article->articleCategory->id?> year-<?=date("Y", strtotime($article->created_on))?>">
                        <div class="news-item-image">
                            <div class="news-item-image-inner" style="background-image: url('<?=Url::base(true)?>/uploads/articles/<?=$article->article_featured_image?>')">
                                <img src="<?=Url::base(true)?>/uploads/articles/<?=$article->article_featured_image?>" alt="" />
                                <div class="news-item-image-decor"></div>
                            </div>
                        </div>
                        <div class="news-item-body">
                            <div class="news-item-category">
                                <div class="news-item-category-box" style="background-color: <?=$article->articleCategory->category_color?>"><?=$article->articleCategory->category_name?></div>
                            </div>
                            <div class="news-item-title">
                                <div class="news-item-title-inner">
                                    <?=$article->article_title?>
                                </div>
                            </div>
                            <div class="news-item-short-desc">
                                <div class="news-item-short-desc-inner">
                                    <?=StringComponent::csubstr($article->article_short_description, 0, 100)?>
                                </div>
                            </div>
                            <div class="news-item-date"><?=date("d/m/Y", strtotime($article->created_on))?></div>
                        </div>
                    </div>
                </a>
                <?php if ($i%2==1):?>
                <div class="clear clear-2"></div>
                <?php endif;?>
                <?php if ($i%3==2):?>
                <div class="clear clear-3"></div>
                <?php endif;?>
            <?php endforeach;?>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(window).on("load", function(){
    var $grid = $(".article-container").isotope({
        itemSelector: '.news-item',
        layoutMode: 'fitRows',
        filter: function() {
            var $this = $(this);
            var searchResult = qsRegex ? $this.text().match( qsRegex ) : true;
            var filterResult = filterValue ? $this.is( filterValue ) : true;
            return searchResult && filterResult;
        },
    });

    $("#dropdown-category-filter").change(function(){
        $(".article-category-item").removeClass("active");
        if ($(this).val() != "") {
            var id = $(this).val().split("-")[1];
            $("#article-category-item-"+id).addClass("active");
        } else {
            $("#article-category-item-all").addClass("active");
        }
        
        filters['category'] = $(this).val();
        
        filterValue = concatValues( filters );

        $grid.isotope();
    });

    $("#dropdown-year-filter").change(function(){
        filters['year'] = $(this).val();
        
        filterValue = concatValues( filters );

        $grid.isotope();
    });

    $(".article-category-item").click(function(){
        $(".article-category-item").removeClass("active");
        $(this).addClass("active");

        var id = $(this).attr("id").split("-")[3];

        if (id != "all") {
            filters['category'] = '.cat-'+id;
            $("#dropdown-category-filter").val('.cat-'+id);
        } else {
            filters['category'] = "";
            $("#dropdown-category-filter").val('');
        }

        filterValue = concatValues( filters );

        $grid.isotope();
    });

    var $quicksearch = "";
    $(".search-article-button").click(function(){
        if ($('#text-search').val() == "") {
            qsRegex = "";
        } else {
            qsRegex = new RegExp( $('#text-search').val(), 'gi' );
        }
        $grid.isotope();
    });

    // var $quicksearch = $('#text-search').keyup( debounce( function() {
    //     qsRegex = new RegExp( $quicksearch.val(), 'gi' );
    //     $grid.isotope();
    // }) );
});

var filters = {};
var filterValue;
var qsRegex;

function concatValues( obj ) {
    var value = '';
    for ( var prop in obj ) {
        value += obj[ prop ];
    }
    return value;
}

function debounce( fn, threshold ) {
    var timeout;
    threshold = threshold || 100;
    return function debounced() {
        clearTimeout( timeout );
        var args = arguments;
        var _this = this;
        function delayed() {
            fn.apply( _this, args );
        }
        timeout = setTimeout( delayed, threshold );
    };
}
</script>