<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-product">
	<h1>Focus On Quality</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-category">
    <div class="inline-container">
        <div class="section-title">Product Category</div>
        <div class="section-content">
            <div class="category-container">
            <?php foreach($categories as $i => $cat):?>
                <a href="#">
                    <div class="category-item <?=$cat->product_category_slug == $category->product_category_slug ? 'active' : ''?>">
                        <?=$cat->product_category_name?>
                        <img src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
                    </div>
                </a>
                <?php if ($i%2==1):?>
                <div class="clear clear-2"></div>
                <?php endif;?>
                <?php if ($i%3==2):?>
                <div class="clear clear-3"></div>
                <?php endif;?>
                <?php if ($i%4==3):?>
                <div class="clear clear-4"></div>
                <?php endif;?>
            <?php endforeach;?>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>

<div class="section most-bottom-section" id="section-category-brand">
	<div class="inline-container">
		<h2 class="section-title2"><?=$category->product_category_name?></h2>
        <div class="brands-accordion">
        <?php foreach($subCategories as $i => $subCategory):?>
            <div class="accordion-item" id="accordion-item-<?=$subCategory->id?>">
                <div class="accordion-header"><?=$subCategory->product_category_name?></div>
                <div class="accordion-body">
                    <div class="category-brand-title">The Brands</div>
                    <div class="category-brand-container">
                    <?php foreach($brands[$i] as $j => $brand):?>
                        <div class="category-brand-item">
                            <img src="<?=Url::base(true)?>/uploads/categorybrands/<?=$brand->product_brand_image?>" alt="" />
                        </div>
                        <?php if ($j%2==1):?>
                        <div class="clear clear-2"></div>
                        <?php endif;?>
                        <?php if ($j%3==2):?>
                        <div class="clear clear-3"></div>
                        <?php endif;?>
                    <?php endforeach;?>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
        <?php endforeach;?>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function(){
	$('.accordion-item').click(function(){
		// var header = $(this).find('.accordion-header');
		var body = $(this).find('.accordion-body');
		if ($(this).hasClass('active')) {
			$(this).removeClass('active');
			body.stop().slideUp();
		} else {
			$(this).addClass('active');
			body.stop().slideDown();
		}
	});
});
</script>