<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-product">
	<h1>Focus On Quality</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-category">
    <div class="inline-container">
        <div class="section-title">Product Category</div>
        <div class="section-content">
            <div class="category-container">
            <?php foreach($categories as $i => $category):?>
                <a href="<?=Url::base(true)?>/product/<?=$category->product_category_slug?>">
                    <div class="category-item">
                        <?=$category->product_category_name?>
                        <img src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
                    </div>
                </a>
                <?php if ($i%2==1):?>
                <div class="clear clear-2"></div>
                <?php endif;?>
                <?php if ($i%3==2):?>
                <div class="clear clear-3"></div>
                <?php endif;?>
                <?php if ($i%4==3):?>
                <div class="clear clear-4"></div>
                <?php endif;?>
            <?php endforeach;?>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>
<div class="section most-bottom-section" id="section-category2">
    <div class="inline-container">
        <div class="section-content">
            <div class="category2-container">
            <?php foreach($categories as $i => $category):?>
                <a href="<?=Url::base(true)?>/product/<?=$category->product_category_slug?>">
                    <div class='category2-item'>
                        <div class="category2-image" style="background-image: url('<?=Url::base(true)?>/uploads/categories/<?=$category->product_category_image?>');">
                            <div class="category2-image-inner"></div>
                        </div>
                        <div class="category2-name"><?=$category->product_category_name?></div>
                    </div>
                </a>
                <?php if ($i%2==1):?>
                <div class="clear clear-2"></div>
                <?php endif;?>
                <?php if ($i%3==2):?>
                <div class="clear clear-3"></div>
                <?php endif;?>
            <?php endforeach;?>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>