<?php
use yii\helpers\Url;
use app\components\BaseController;
use common\models\Setting;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-contact">
	<h1>Get In Touch</h1>
	<div class="banner-line"></div>
</div>

<div class="section most-bottom-section" id="section-contact">
    <div class="inline-container">
        <div class="section-title">Contact Us</div>
        <div class="section-content">
			<div class="contact-company-title">PT HAKIKI DONARTA</div>
			<div class="contact-wrapper">
				<div class="contact-title">Head Office</div>
				<div class="contact-item">
					<div class="contact-icon"><img src="<?=Url::base(true)?>/img/icon-address.png" alt="" /></div>
					<div class="contact-value"><?=Setting::getSettingValueByName('headoffice_address')?></div>
				</div>
				<div class="contact-item">
					<div class="contact-icon"><img src="<?=Url::base(true)?>/img/icon-phone.png" alt="" /></div>
					<div class="contact-value">
						<?=Setting::getSettingValueByName('headoffice_phone_label')?>
						<?php $phone = Setting::getSettingValueByName('headoffice_phone_label2');?>
						<?php if (!empty($phone)):?>
						<br/>
						<?=Setting::getSettingValueByName('headoffice_phone_label2')?>
						<?php endif;?>
					</div>
				</div>
				<div class="contact-item">
					<div class="contact-icon"><img src="<?=Url::base(true)?>/img/icon-email.png" alt="" /></div>
					<div class="contact-value"><?=Setting::getSettingValueByName('headoffice_email')?></div>
				</div>
			</div>
			<div class="contact-wrapper">
				<div class="contact-title">West Region Office</div>
				<div class="contact-item">
					<div class="contact-icon"><img src="<?=Url::base(true)?>/img/icon-address.png" alt="" /></div>
					<div class="contact-value"><?=Setting::getSettingValueByName('west_office_address')?></div>
				</div>
				<div class="contact-item">
					<div class="contact-icon"><img src="<?=Url::base(true)?>/img/icon-phone.png" alt="" /></div>
					<div class="contact-value">
						<?=Setting::getSettingValueByName('west_office_phone_label')?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>