<?php
use yii\helpers\Url;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section banner" id="banner-distribution">
	<h1>Endless Possible</h1>
	<div class="banner-line"></div>
</div>

<div class="section" id="section-indo-map">
    <div class="inline-container">
        <div class="section-title">Indonesia Distribution</div>
		<div class="section-content">
			<img src="<?=Url::base(true)?>/img/indonesia-map.png" alt="" />
		</div>
	</div>
</div>
<div class="section" id="section-indo-dist">
	<div class="inline-container">
		<div class="section-content">
			<div class="indo-dist-container">
			<?php foreach($distCols as $i => $distCol):?>
				<div class="dist-col">
					<div class="dist-province-name"><span><?=empty($distCol['province_name']) ? "&nbsp;" : $distCol['province_name']?></span></div>
					<div class="dist-city-container">
					<?php foreach($distCol['cities'] as $city):?>
						<div class="dist-city-name"><?=$city?></div>
					<?php endforeach;?>
					</div>
				</div>
				<?php if ($i % 2 == 1):?>
				<div class="clear clear-2"></div>
				<?php endif;?>
				<?php if ($i % 3 == 2):?>
				<div class="clear clear-3"></div>
				<?php endif;?>
				<?php if ($i % 4 == 3):?>
				<div class="clear clear-4"></div>
				<?php endif;?>
				<?php if ($i % 6 == 5):?>
				<div class="clear clear-6"></div>
				<?php endif;?>
			<?php endforeach;?>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>
<div class="section" id="section-indo-dist-mobile">
	<div class="inline-container">
		<div class="section-content">
			<div class="indo-dist-accordion">
			<?php foreach($distributions as $i => $distribution):?>
				<div class="accordion-item" id="accordion-item-<?=$i?>">
					<div class="accordion-header"><?=$distribution->dist_province_name?></div>
					<div class="accordion-body">
					<?php foreach($distribution->indoDistributionDetails as $detail):?>
						<div class="dist-city-name"><?=$detail->dist_city_name;?></div>
					<?php endforeach;?>
					</div>
				</div>
			<?php endforeach;?>
			</div>
		</div>
	</div>
</div>
<div class="section" id="section-segmentation">
	<div class="inline-container">
		<div class="section-content">
			<fieldset>
				<legend>INDONESIA MARKET SEGMENTATION</legend>
				<div class="segmentation-container">
				<?php foreach($segmentations as $i => $segmentation):?>
					<div class="segmentation-item <?=$i%3 == 2 ? 'end-3' : ''?> <?=$i%2 == 1 ? 'end-2' : ''?>">
						<div class="segmentation-text"><?=$segmentation->segmentation_name?></div>
					</div>
				<?php endforeach;?>
				</div>
			</fieldset>
		</div>
	</div>
</div>
<div class="section most-bottom-section" id="section-international">
    <div class="inline-container">
        <div class="section-title">International Distribution</div>
        <div class="section-content">
			<div class="distribution-area">
				<div class="international-title">
					<div class="international-text">DISTRIBUTION AREA</div>
				</div>
				<div class="inter-dist-container">
				<?php foreach($interDistributions as $i => $interDistribution):?>
					<div class="inter-dist-item"><?=$interDistribution->dist_country?></div>
					<?php if ($i%2==1):?>
					<div class="clear clear-2"></div>
					<?php endif;?>
					<?php if ($i%3==2):?>
					<div class="clear clear-3"></div>
					<?php endif;?>
				<?php endforeach;?>
					<div class="clear"></div>
				</div>
			</div>
			<div class="market-segmentation">
				<div class="international-title">
					<div class="international-text">MARKET SEGMENTATION</div>
				</div>
				<img src="<?=Url::base(true)?>/img/icon-btob.png" alt="" />
				<div class="business-to-business">BUSINESS TO BUSINESS</div>
			</div>
			<div class="clear"></div>
		</div>
	</div>
</div>
<script type="text/javascript">
$(document).ready(function(){
	$('.accordion-item').click(function(){
		// var header = $(this).find('.accordion-header');
		var body = $(this).find('.accordion-body');
		if ($(this).hasClass('active')) {
			$(this).removeClass('active');
			body.stop().slideUp();
		} else {
			$(this).addClass('active');
			body.stop().slideDown();
		}
	});
});
</script>