<?php
use app\components\BaseController;
use yii\helpers\Url;
use common\components\CurrencyComponent;
use frontend\components\StringComponent;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section" id="section-slideshow">
    <div class="slide-decoration-top"><img src="<?=Url::base(true)?>/img/slide-decoration-top.png" alt="" /></div>
    <div class="slide-container">
    <?php foreach($slides as $i => $slide):?>
        <div class="slide-item" id="slide-item-<?=$i?>">
            <div class="slide-image-container">
                <img class="slide-image-desktop" src="<?=Url::base(true)?>/uploads/slides/<?=$slide->slide_image_filename?>" alt="" />
                <img class="slide-image-mobile" src="<?=Url::base(true)?>/uploads/slides/mobile/<?=$slide->slide_image_mobile_filename?>" alt="" />
            </div>
        </div>
    <?php endforeach;?>
    </div>

    <div class="slide-desc-boxes">
    <?php foreach($slides as $i => $slide):?>
        <div id="slide-box-<?=$i?>" class="slide-desc-box" style="border-right: 1px solid <?=$slide->slide_color?>; border-left: 1px solid <?=$slide->slide_color?>; border-bottom: 6px solid <?=$slide->slide_color?>;">
            <div class="slide-desc-box-header" style="background-color: <?=$slide->slide_color?>">
                <span class="slide-desc-box-title"><?=$slide->slide_title?></span>
            </div>
            <div class="slide-desc-box-body">
                <div class="slide-desc-box-desc"><?=$slide->slide_desc?></div>
                <div class="slide-desc-box-link">
                <?php if(!empty($slide->slide_url) && !empty($slide->slide_url_label) && !empty($slide->slide_url_icon)):?>
                    <a target="_blank" style="color: <?=$slide->slide_color?>" href="<?=$slide->slide_url?>"><img src="<?=Url::base(true)?>/uploads/slides/icon/<?=$slide->slide_url_icon?>" alt="" /> <?=$slide->slide_url_label?></a>
                <?php endif;?>
                <?php if(!empty($slide->slide_url2) && !empty($slide->slide_url_label2) && !empty($slide->slide_url_icon2)):?>
                    <?php if(!empty($slide->slide_url) && !empty($slide->slide_url_label) && !empty($slide->slide_url_icon)):?>
                        |
                    <?php endif;?>
                    <a target="_blank" style="color: <?=$slide->slide_color?>" href="<?=$slide->slide_url2?>"><img src="<?=Url::base(true)?>/uploads/slides/icon/<?=$slide->slide_url_icon2?>" alt="" /> <?=$slide->slide_url_label2?></a>
                <?php endif;?>
                </div>
            </div>
        </div>
    <?php endforeach;?>
    </div>

    <div class="carousel-logo-container">
    <?php foreach($slides as $i => $slide):?>
        <div class="carousel-item" data-carousel-index="<?=$i?>"><img src="<?=Url::base(true)?>/uploads/slides/logo/<?=$slide->slide_image_logo_filename?>" alt="" /></div>
    <?php endforeach;?>
    </div>
    <div class="slide-decoration-bottom">
        <img src="<?=Url::base(true)?>/img/slide-decoration-bottom.png" alt="" />
        <div class="current-slide-line"></div>
    </div>
</div>

<div class="section" id="section-brand">
    <div class="inline-container">
        <div class="brand-link-container">
            <div class="brand-link-left">
                Find Out About
            </div>
            <a href="<?=Url::base(true)?>/about/brand">
                <div class="brand-link">
                    <img src="<?=Url::base(true)?>/img/icon-about-brand.png" alt="" /> Our Brand & Principals
                </div>
            </a>
            <a href="<?=Url::base(true)?>/about/facility">
                <div class="brand-link">
                    <img src="<?=Url::base(true)?>/img/icon-about-facility.png" alt="" /> Facility & Technology
                </div>
            </a>
            <a href="<?=Url::base(true)?>/about/certification">
                <div class="brand-link-right">
                    <img src="<?=Url::base(true)?>/img/icon-about-standard.png" alt="" /> Standard & Certification
                </div>
            </a>
            <div class="clear"></div>
        </div>

        <div class="our-brand-container">
            <fieldset>
                <legend>Our Brands</legend>
                <div class="our-brand-decor"></div>
                <div class="our-brand-body">
                    <div class="our-brand-image-mobile">
                        <img src="<?=Url::base(true)?>/img/our-brand-image.jpg" alt=""/>
                    </div>
                    <div class="our-brand-subtitle">Explore by Category</div>
                    <div class="our-brand-col">
                    <?php for($i = 0; $i < ceil(count($categories) / 2); $i++):?>
                        <a href="<?=Url::base(true)?>/product/<?=$categories[$i]->product_category_slug?>">
                            <div class="our-brand-item">
                                <?=$categories[$i]->product_category_name?>
                                <img src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
                            </div>
                        </a>
                    <?php endfor;?>
                    </div>
                    <div class="our-brand-col">
                    <?php for($i = ceil(count($categories)/2); $i < count($categories); $i++):?>
                        <a href="<?=Url::base(true)?>/product/<?=$categories[$i]->product_category_slug?>">
                            <div class="our-brand-item">
                                <?=$categories[$i]->product_category_name?>
                                <img src="<?=Url::base(true)?>/img/icon-mega-menu-hover.png" alt="" />
                            </div>
                        </a>
                    <?php endfor;?>
                    </div>
                    <div class="our-brand-col our-brand-image">
                        <img src="<?=Url::base(true)?>/img/our-brand-image.jpg" alt=""/>
                    </div>
                    <div class="clear"></div>
                </div>
            </fieldset>
        </div>
    </div>
</div>

<div class="section most-bottom-section" id="section-news">
    <div class="inline-container">
        <div class="section-title">News & Updates</div>
    </div>
    <div class="news-carousel-wrapper">
        <div class="news-carousel">
        <?php foreach($articles as $article):?>
            <a href="<?=Url::base(true)?>/news/<?=$article->article_slug?>">
                <div class="news-item">
                    <div class="news-item-image">
                        <div class="news-item-image-inner" style="background-image: url('<?=Url::base(true)?>/uploads/articles/<?=$article->article_featured_image?>')">
                            <img src="<?=Url::base(true)?>/uploads/articles/<?=$article->article_featured_image?>" alt="" />
                            <div class="news-item-image-decor"></div>
                        </div>
                    </div>
                    <div class="news-item-body">
                        <div class="news-item-category">
                            <div class="news-item-category-box" style="background-color: <?=$article->articleCategory->category_color?>"><?=$article->articleCategory->category_name?></div>
                        </div>
                        <div class="news-item-title">
                            <div class="news-item-title-inner">
                                <?=$article->article_title?>
                            </div>
                        </div>
                        <div class="news-item-short-desc">
                            <div class="news-item-short-desc-inner">
                                <?=StringComponent::csubstr($article->article_short_description, 0, 100)?>
                            </div>
                        </div>
                        <div class="news-item-date"><?=date("d/m/Y", strtotime($article->created_on))?></div>
                    </div>
                </div>
            </a>
        <?php endforeach;?>
        </div>
    </div>
    <div class="news-button hakiki-style-button">
        <a href="<?=Url::base(true)?>/news">
            <div class="hakiki-style-button-inner">
                <div class="button-icon"><img src="<?=Url::base(true)?>/img/icon-button-news.png" alt="" /></div>
                <div class="button-text">View All News</div>
            </div>
        </a>
    </div>
</div>

<script type="text/javascript">
$('.slide-container').on('beforeChange', function(event, slick, direction){
    var id = parseInt(slick.currentSlide)+1;
    if (id >= slick.slideCount) {
        id = 0;
    }
    $(".slide-desc-box").hide();
    $("#slide-box-"+id).show();

    var a = 2;
    if ($(window).width() <= 800) {
        a = 1;
    }

    var goTo = parseInt(id - a);
    if (goTo < 0) {
        goTo = goTo + slick.slideCount;
    }
    $('.carousel-logo-container').slick('slickGoTo', goTo);
});

$(document).ready(function(){
    $('.slide-container').slick({
        slidesToShow: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        arrows: true,
        infinite: true,
    });

    $(".slide-desc-box").hide();
    $("#slide-box-0").show();

    $(".carousel-logo-container").slick({
        slidesToShow: 5,
        autoplay: false,
        autoplaySpeed: 4000,
        arrows: false,
        infinite: true,
        responsive: [
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 3,
                }
            },
            // {
            //     breakpoint: 450,
            //     settings: {
            //         slidesToShow: 1,
            //     }
            // }
        ]
    });

    var carousel = $('.carousel-logo-container').slick('getSlick');
    var a = 2;
    if ($(window).width() <= 800) {
        a = 1;
    }
    $(".carousel-logo-container").slick('slickGoTo', carousel.slideCount - a);

    $(".news-carousel").slick({
        slidesToShow: 4,
        autoplay: false,
        autoplaySpeed: 4000,
        arrows: true,
        infinite: true,
        responsive: [
            {
                breakpoint: 1150,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3,
                }
            },
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2
                }
            },
            {
                breakpoint: 600,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    centerMode: true
                }
            }
        ]
    });
});
</script>