<?php
use app\components\BaseController;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section brown" id="section-login">
    <div class="section-content">
        <div class="inline-container">
            <div class="login-form-container">
                
                <div class="column-title">SIGN IN</div>
                <?php 
                    foreach(Yii::$app->session->getAllFlashes() as $key => $message)
                        echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
                ?>
                <?php $form = ActiveForm::begin(['id' => 'login-form', 'enableClientValidation' => false]); ?>
                <?php echo $form->errorSummary($model);?>
                    <?= $form->field($model, 'email')->textInput(['placeholder' => 'Email', 'class'=>'marnova-style-field'])->label(false) ?>
                    <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Password', 'class'=>'marnova-style-field'])->label(false) ?>
                    <div class="login-button">
                        <input type="submit" name="btn-login" value="SIGN IN" class="marnova-style-button"/>
                    </div>
                    <div class="forget-password">
                        <a href="<?=Url::base(true)?>/forgetpassword">Forget Password?</a>
                    </div>
                    <div class="clear"></div>
                <?php ActiveForm::end(); ?>
            </div>
            <div class="sign-up-form-container">
                <div class="column-title">CREATE ACCOUNT</div>
                <?php $form = ActiveForm::begin(['id' => 'register-form', 'enableClientValidation' => false]); ?>
                    <?php echo $form->errorSummary($modelSignup);?>
                    <?= $form->field($modelSignup, 'member_fullname')->textInput(['placeholder' => 'Full Name', 'class'=>'marnova-style-field'])->label(false) ?>
                    <?= $form->field($modelSignup, 'member_email')->textInput(['placeholder' => 'Email', 'class'=>'marnova-style-field'])->label(false) ?>
                    <?= $form->field($modelSignup, 'password')->passwordInput(['placeholder' => 'Password', 'class'=>'marnova-style-field'])->label(false) ?>
                    <?= $form->field($modelSignup, 'confirm')->passwordInput(['placeholder' => 'Confirm Password', 'class'=>'marnova-style-field'])->label(false) ?>
                    <input type="submit" name="btn-signup" value="CREATE" class="marnova-style-button"/>
                    <input type="hidden" name="recaptcha_response" id="recaptchaResponse">
                <?php ActiveForm::end(); ?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>
<script src="https://www.google.com/recaptcha/api.js?render=6LfS_kAaAAAAAHfccNmxs6VSgXe8bQVpNEQhAqYv"></script>
<script type="text/javascript">
    grecaptcha.ready(function () {
        grecaptcha.execute('6LfS_kAaAAAAAHfccNmxs6VSgXe8bQVpNEQhAqYv', { action: 'contact' }).then(function (token) {
            var recaptchaResponse = document.getElementById('recaptchaResponse');
            recaptchaResponse.value = token;
        });
    });
</script>