<?php
use yii\helpers\Url;
use yii\helpers\Html;
use app\components\BaseController;
use yii\widgets\ActiveForm;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
?>

<div class="section" id="section-search-form">
	<div class="inline-container">
		<?php $form = ActiveForm::begin(['id' => 'search-page-form', 'enableClientValidation' => false, 'method' => 'get', 'action' => Url::base(true)."/search"]); ?>
			<div class="button-search-wrapper">
				<button type="submit"><img src="<?=Url::base(true)?>/img/icon-search-white.png" alt="" /></button>
			</div>
			<div class="text-search-wrapper">
				<?=Html::textInput('keyword', isset($_GET['keyword']) ? $_GET['keyword'] : "", ['placeholder' => 'Type in here', 'class' => 'text-search'])?>
			</div>
			<div class="wrapper"></div>
		<?php ActiveForm::end(); ?>
	</div>
</div>
<div class="section most-bottom-section" id="section-search-result">
	<div class="inline-container">
		<div class="result-container">
		<?php foreach($results as $i => $result):?>
			<div class="result-item <?=$i%2 == 0 ? 'left' : 'right'?>">
				<div class="result-title"><?=$result['title']?></div>
				<div class="result-desc">
					<?=$result['desc'] == '' ? 'See More' : $result['desc']?>
				</div>
			</div>
			<?php if ($i%2 == 1):?>
			<div class="clear"></div>
			<?php endif;?>
		<?php endforeach;?>
		</div>
	</div>
</div>
<script type="text/javascript">
$(window).on("load", function(){
	$(".result-container").isotope({
        itemSelector: '.result-item',
        layoutMode: 'fitRows',
    });
});
</script>